// RatEnvMessage.cpp start

/*
 * Modified, CGP, 9/19/00
 *		To use egocentric directions (e.g., Rotate) instead of N, E, W, S.
 */

#include <Messenger.h>
#include <Message.h>
#include <String.h>
#include <stdio.h>

#include "RatPlugin.h"
#include "EnvironmentConstants.h"
#include "Debug.h"
#include "RatEnvMessage.h"

/*******************************************************
* Functions to pass messages to the environment
*
* Change, CGP, 11/17/00
*   Change RatEnvMessage constructor to use BLooper constructor.
*   This change is temporary until we get PortMessage and PortableMessage
*   changes implemented.
*******************************************************/

RatEnvMessage::RatEnvMessage(BLooper *env) : EnvMessage(env)
{
}

bool RatEnvMessage::IsOpen()
{
	BMessage msg(RATMSG_IS_OPEN);
	BMessage reply;
	bool result;
	int error;
	char buffer[50];
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "RatEnvMessage::IsOpen: Error creating messenger: ", strerror(status));
	}

	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug("RatEnvMessage::IsOpen: Error sending message");
	}
	
	if ((error = reply.FindBool("flag", &result)) != B_OK) {
		Debug('e', "RatEnvMessage::IsOpen: Error decoding reply: ", strerror(error));
		int count = reply.CountNames(B_ANY_TYPE);
		sprintf(buffer, "%d", count);
		Debug('e', "RatEnvMessage::IsOpen: number of fields was: ", buffer);
		
		if (! reply.IsReply()) {
			Debug('e', "RatEnvMessage::IsOpen: Message was NOT a reply!!!!");
		}
	}
	
	delete messenger;
	
	return result;
}

void RatEnvMessage::Rotate(int degrees)
{
	BMessage msg(RATMSG_ROTATE);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug("RatEnvMessage::Rotate: Error creating messenger: ", strerror(status));
	}
	
	msg.AddInt16("degrees", (int16) degrees);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug("RatEnvMessage::Rotate: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug("RatEnvMessage::Rotate: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}

bool RatEnvMessage::Move()
{
	BMessage msg(RATMSG_MOVE);
	BMessage reply;
	status_t status;
	bool result = false;
	int error;
	char buffer[50];
		
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "RatEnvMessage::Move: Error creating messenger: ", strerror(status));
	}

	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "RatEnvMessage::Move: Error sending message");
	}

	if ((error = reply.FindBool("flag", &result)) != B_OK) {
		Debug('e', "RatEnvMessage::Move: Error decoding reply: ", strerror(error));
		int count = reply.CountNames(B_ANY_TYPE);
		sprintf(buffer, "%d", count);
		Debug('e', "RatEnvMessage::Move: number of fields was: ", buffer);
		
		if (! reply.IsReply()) {
			Debug('e', "RatEnvMessage::Move: Message was NOT a reply!!!!");
		}
	}
	
	delete messenger;
	return result;
}

bool RatEnvMessage::EatFood()
{
	BMessage msg(RATMSG_EATFOOD);
	BMessage reply;
	status_t status;
	bool result = false;
	int error;
	char buffer[50];
		
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "RatEnvMessage::EatFood: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "RatEnvMessage::EatFood: Error sending message");
	}
	
	if ((error = reply.FindBool("flag", &result)) != B_OK) {
		Debug('e', "RatEnvMessage::EatFood: Error decoding reply: ", strerror(error));
		int count = reply.CountNames(B_ANY_TYPE);
		sprintf(buffer, "%d", count);
		Debug('e', "RatEnvMessage::EatFood: number of fields was: ", buffer);
		
		if (! reply.IsReply()) {
			Debug('e', "RatEnvMessage::EatFood: Message was NOT a reply!!!!");
		}
	}
	
	delete messenger;
	return result;
}

bool RatEnvMessage::FoodHere()
{
	BMessage msg(RATMSG_FOODHERE);
	BMessage reply;
	bool result;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "RatEnvMessage::FoodHere: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "RatEnvMessage::FoodHere: Error sending message");
	}
	
	if ((status = reply.FindBool("flag", &result)) != B_OK) {
		Debug('e', "RatEnvMessage::FoodHere: Error decoding reply: ", strerror(status));
	}
	
	delete messenger;
	
	return result;
}

float *RatEnvMessage::Look()
{
	BMessage msg(RATMSG_LOOK);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "RatEnvMessage::Look: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "RatEnvMessage::Look: Error sending message");
	}
	
	delete messenger;
	
	float *view = new float[LANDMARK_VIEW_WIDTH];
	if (view == NULL) {
		Debug('e', "RatEnvMessage::Look: Could not allocate memory");
		return NULL;
	}
	
	for (int i=0; i < LANDMARK_VIEW_WIDTH; i++) {
		// View has been placed in message as an array of floats under same name,
		// so "Find" with indices. See Find BMessage documentation.
		if ((status = reply.FindFloat("view", i, &(view[i]))) != B_OK) {
			Debug('e', "RatEnvMessage::Look: Error decoding reply: ", strerror(status));
			delete view;
			view = NULL;
			break;
		}
	}
	
	return view;
}

// RatEnvMessage.cpp ends
